/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.packets.instances;

import io.netty.buffer.ByteBuf;
import java.util.List;
import minecrafttransportsimulator.entities.components.AEntityD_Definable;
import minecrafttransportsimulator.entities.components.AEntityF_Multipart;
import minecrafttransportsimulator.items.components.AItemSubTyped;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperInventory;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.packets.components.APacketEntityInteract;
import minecrafttransportsimulator.packloading.PackMaterialComponent;

public class PacketEntityColorChange
extends APacketEntityInteract<AEntityD_Definable<?>, IWrapperPlayer> {
    private final AItemSubTyped<?> newItem;
    private final int recipeIndex;

    public PacketEntityColorChange(AEntityD_Definable<?> entity, IWrapperPlayer player, AItemSubTyped<?> newItem, int recipeIndex) {
        super(entity, player);
        this.newItem = newItem;
        this.recipeIndex = recipeIndex;
    }

    public PacketEntityColorChange(ByteBuf buf) {
        super(buf);
        this.newItem = (AItemSubTyped)PacketEntityColorChange.readItemFromBuffer(buf);
        this.recipeIndex = buf.readInt();
    }

    @Override
    public void writeToBuffer(ByteBuf buf) {
        super.writeToBuffer(buf);
        PacketEntityColorChange.writeItemToBuffer(this.newItem, buf);
        buf.writeInt(this.recipeIndex);
    }

    @Override
    public boolean handle(AWrapperWorld world, AEntityD_Definable<?> entity, IWrapperPlayer player) {
        if (!world.isClient() && !player.isCreative()) {
            List<PackMaterialComponent> materials;
            IWrapperInventory inventory = player.getInventory();
            if (inventory.hasMaterials(materials = PackMaterialComponent.parseFromJSON(this.newItem, this.recipeIndex, false, true, false, false))) {
                inventory.removeMaterials(materials);
            } else {
                return false;
            }
        }
        entity.updateSubDefinition(this.newItem.subDefinition.subName);
        if (entity instanceof AEntityF_Multipart) {
            ((AEntityF_Multipart)entity).parts.forEach(part -> part.updateTone(true));
        }
        return true;
    }
}

